﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<script runat="server">

    public enum TypZakresu {
        Planowane, Odbyte, Niewykonane
    }

    public enum Status {
            Anulowane, Nieanulowane, Wszystkie
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool wydzial = true;
        [Caption("Nazwa wydziału")]
        public bool Wydzial {
            get { return wydzial; }
            set {
                wydzial = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
    
    public class Params: ContextBase {
        public Params(Context context): base(context) {
            okres = GetOkres();
        }
    
        TypZakresu zakres;
        [Caption("Zakres")]
        [Priority(10)]
        public TypZakresu Zakres {
            get { return zakres ; }
            set {
                zakres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        DefinicjaBadaniaLekarskiego[] definicja;
        [Caption("Definicje")]
        [Priority(20)]
        public DefinicjaBadaniaLekarskiego[] Definicja {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicja() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefBadanLek.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }                    
       
        FromTo okres;
        [Required]
		[Caption("Raport za okres")]
        [Priority(30)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    value = GetOkres();
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        FromTo GetOkres() {
            return new YearMonth(ActualDate.Today(Context)).ToFromTo();
        }

        Status typ = Status.Wszystkie;
        [Caption("Typ")]
        [Priority(40)]
        public Status Typ {
            get { return typ; }
            set {
                typ = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    Params pars = null;
    [Context(Required = true)]
    public Params Param {
        set {
            definicja = value.Definicja;
            pars = value;
        }
    }

    DefinicjaBadaniaLekarskiego[] definicja;

    RowCondition condition = RowCondition.Empty;

    void OnContextLoad(Object sender, EventArgs args) {
        object[] lst = new object[1];
        lst[0] = "(razem)";
        
		ReportHeader1["DEFINICJA"] = Info("Definicja", "Definicje", (definicja != null) ? definicja : lst);
        ReportHeader1["OKRES"] = Info("Za okres", "", pars.Okres.ToString());
        ReportHeader1["ZAKRES"] = Info("Zakres", "", pars.Zakres.ToString());
        ReportHeader1["TYP"] = Info("Typ", "", pars.Typ.ToString());

        if (definicja != null && definicja.Length > 0)
            condition &= new FieldCondition.In("Definicja", definicja);

        if (pars.Typ != Status.Wszystkie)
        {
            colAnulowany.Visible = false;
            condition &= new FieldCondition.Equal("Anulowany", pars.Typ == Status.Anulowane ? true : false);
        }

        switch (pars.Zakres) {
            case TypZakresu.Planowane:
                condition &= new FieldCondition.Contain("Termin", pars.Okres);
            break;
            case TypZakresu.Odbyte:
                condition &= new FieldCondition.Contain("Data", pars.Okres);
            break;
            case TypZakresu.Niewykonane:
                condition &= new FieldCondition.Contain("Termin", pars.Okres);
                condition &= new FieldCondition.Equal("Data", Date.Empty);
            break;
        }

        Row[] rows = (Row[])dc[typeof(Row[])];
        IEnumerable lista = rows;
        bool UI = rows.Length > 0 ? (rows[0] is Pracownik) : false;
        if (!UI)
            lista = KadryModule.GetInstance(dc).Pracownicy.WgNazwiska;

        Grid1.DataSource = lista;

        colWydzial.Visible = srpars.Wydzial;
        dc.Landscape = srpars.Wydzial;
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        Pracownik prac = (Pracownik)args.Row;
        SubTable st = prac.BadaniaLekarskie;
        st = st[condition];

        bool any = false;
        
        foreach (BadanieLekarskie bdl in st) {
            any = true;
            colNazwa.AddLine(bdl.Nazwa);
            colTermin.AddLine(bdl.Termin);
            colData.AddLine(bdl.Data);
            colOpis.AddLine(bdl.Opis);
            colAnulowany.AddLine(bdl.Anulowany ? "TAK": "NIE");
        }

        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, ToHTML(lst[0]));
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = ToHTML(obj);
            else
                info += "</strong>, <strong>" + ToHTML(obj);
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }

    static string ToHTML(object value) {
        return HttpUtility.HtmlEncode(value.ToString());
    }
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Badania okresowe</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="BadaniaOkresowe" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Lista badań okresowych|%DEFINICJA%%OKRES%%ZAKRES%%TYP%"
            runat="server"></cc1:ReportHeader>
        <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Kadry.BadanieLekarskie" onbeforerow="Grid1_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" VAlign="Top" DataMember="#" Caption="Lp."></ea:GridColumn>
                <ea:GridColumn Width="25" Align="Left" VAlign="Top" DataMember="Pracownik.NazwiskoImię" 
                    Caption="Pracownik" ID="colPrac" NoWrap="True" EncodeHTML="true"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Left" VAlign="Top" DataMember="Workers.Info.Historia.Etat.Wydzial.Kod" Caption="Wydział~Kod" EncodeHTML="true"></ea:GridColumn>
                <ea:GridColumn Width="20" Align="Left" VAlign="Top" DataMember="Workers.Info.Historia.Etat.Wydzial.Nazwa" Caption="Wydział~Nazwa" EncodeHTML="true" ID="colWydzial"></ea:GridColumn>
                <ea:GridColumn Width="20" Align="Left" VAlign="Top" ID="colNazwa" NoWrap="True" Caption="Nazwa" EncodeHTML="true"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Left" VAlign="Top" ID="colTermin" Caption="Termin"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Left" VAlign="Top" Caption="Data wykonania" ID="colData"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Center" VAlign="Top" runat="server" ID="colAnulowany" Caption="Anulowany" EncodeHTML="true"></ea:GridColumn>
                <ea:GridColumn Align="Left" VAlign="Top" runat="server" ID="colOpis" Caption="Opis" EncodeHTML="true"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
    </form>
</body>
</html>
